from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from AccessPointGroupRef import AccessPointGroupRef
from PeerAccessPointRef import PeerAccessPointRef
from CoreGroupAccessPointRef import CoreGroupAccessPointRef;
from utilities import Util
from Property import Property

__name_att__ = "websphere.accesspointgroup.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'AccessPointGroup');

  containmentpath = "%(parentconpath)sAccessPointGroup:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('AccessPointGroup')

  name = Util.getRequiredAttribute(objid, "name", 'AccessPointGroup');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAccessPointGroup");
  exportedObject.put("roleName", "WebSphereAccessPointGroup");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.accesspointgroup.membercommunicationkey", objid, "memberCommunicationKey","AccessPointGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.accesspointgroup.name", objid, "name","AccessPointGroup");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AccessPointGroup");
  proxies = Util.parseConfigIdListAttribute(objid, 'peerAccessPointRefs', 'AccessPointGroup');
  for proxy in proxies:
    if proxy is not None and len(proxy) > 0:
      returndict = Util.createTypeFolder(respath, "PeerAccessPointRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, PeerAccessPointRef._export(proxy, currespath));

  cgaprefs = Util.parseConfigIdListAttribute(objid, 'coreGroupAccessPointRefs', 'AccessPointGroup');
  for cgapref in cgaprefs:
    if cgapref is not None and len(cgapref) > 0:
      returndict = Util.createTypeFolder(respath, "CoreGroupAccessPointRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, CoreGroupAccessPointRef._export(cgapref, currespath));

  apgrefs = Util.parseConfigIdListAttribute(objid, 'AccessPointGroup', 'AccessPointGroup');
  for apgref in apgrefs:
    if apgref is not None and len(apgref) > 0:
      returndict = Util.createTypeFolder(respath, "AccessPointGroupRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, AccessPointGroupRef._export(apgref, currespath));
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AccessPointGroup');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("AccessPointGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.accesspointgroup.name"):
    raise Exception("Resource role properties does not contain websphere.accesspointgroup.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create AccessPointGroup on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);

  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('AccessPointGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("AccessPointGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.accesspointgroup.name"):
    raise Exception("Resource role properties does not contain websphere.accesspointgroup.name!");

  properties = [];
  Util.addIfNotNone(properties, "memberCommunicationKey", roleProperties.optString("websphere.accesspointgroup.membercommunicationkey", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.accesspointgroup.name", None));
  print "Creating AccessPointGroup with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AccessPointGroup", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AccessPointGroup');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('AccessPointGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("AccessPointGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.accesspointgroup.name"):
    raise Exception("Resource role properties does not contain websphere.accesspointgroup.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.accesspointgroup.membercommunicationkey", None), "memberCommunicationKey","AccessPointGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.accesspointgroup.name", None), "name","AccessPointGroup");
  #clear out the peeraccesspoint refs
  atts.append(['AccessPointGroup','']);
  atts.append(['peerAccessPointRefs','']);
  atts.append(['coreGroupAccessPointRefs','']);
  if len(atts) != 0:
    print "Modifying AccessPointGroup with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AccessPointGroup configuration up to date.";

  Property.removeProperties(objid, 'properties',"AccessPointGroup");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('AccessPointGroup');
