from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuthorizationConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuthorizationConfig");
  exportedObject.put("roleName", "WebSphereAuthorizationConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationconfig.usenativeauthorization", objid, "useNativeAuthorization","AuthorizationConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationconfig.usejaccprovider", objid, "useJACCProvider","AuthorizationConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuthorizationConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuthorizationConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthorizationConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "useNativeAuthorization", roleProperties.optString("websphere.authorizationconfig.usenativeauthorization", None));
  Util.addIfNotNone(properties, "useJACCProvider", roleProperties.optString("websphere.authorizationconfig.usejaccprovider", None));
  print "Creating AuthorizationConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuthorizationConfig", parentid, properties);
  Util.popPathElement('AuthorizationConfig');

def update(objid,jsonobject):
  Util.pushPathElement('AuthorizationConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthorizationConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationconfig.usenativeauthorization", None), "useNativeAuthorization","AuthorizationConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationconfig.usejaccprovider", None), "useJACCProvider","AuthorizationConfig");
  if len(atts) != 0:
    print "Modifying AuthorizationConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuthorizationConfig configuration up to date.";

  Util.popPathElement('AuthorizationConfig');
