from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DPFirmwareVersion')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDPFirmwareVersion");
  exportedObject.put("roleName", "WebSphereDPFirmwareVersion");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmwareversion.versionimagefilelocation", objid, "versionImageFileLocation","DPFirmwareVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmwareversion.manufacturedate", objid, "manufactureDate","DPFirmwareVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmwareversion.versionnumber", objid, "versionNumber","DPFirmwareVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmwareversion.usercomment", objid, "userComment","DPFirmwareVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmwareversion.timecreatedinmanager", objid, "timeCreatedInManager","DPFirmwareVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpfirmwareversion.level", objid, "level","DPFirmwareVersion");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DPFirmwareVersion");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DPFirmwareVersion');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DPFirmwareVersion')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPFirmwareVersion resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "versionImageFileLocation", roleProperties.optString("websphere.dpfirmwareversion.versionimagefilelocation", None));
  Util.addIfNotNone(properties, "manufactureDate", roleProperties.optString("websphere.dpfirmwareversion.manufacturedate", None));
  Util.addIfNotNone(properties, "versionNumber", roleProperties.optString("websphere.dpfirmwareversion.versionnumber", None));
  Util.addIfNotNone(properties, "userComment", roleProperties.optString("websphere.dpfirmwareversion.usercomment", None));
  Util.addIfNotNone(properties, "timeCreatedInManager", roleProperties.optString("websphere.dpfirmwareversion.timecreatedinmanager", None));
  Util.addIfNotNone(properties, "level", roleProperties.optString("websphere.dpfirmwareversion.level", None));
  print "Creating DPFirmwareVersion with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DPFirmwareVersion", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPFirmwareVersion');

def update(objid,jsonobject):
  Util.pushPathElement('DPFirmwareVersion')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPFirmwareVersion resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmwareversion.versionimagefilelocation", None), "versionImageFileLocation","DPFirmwareVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmwareversion.manufacturedate", None), "manufactureDate","DPFirmwareVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmwareversion.versionnumber", None), "versionNumber","DPFirmwareVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmwareversion.usercomment", None), "userComment","DPFirmwareVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmwareversion.timecreatedinmanager", None), "timeCreatedInManager","DPFirmwareVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpfirmwareversion.level", None), "level","DPFirmwareVersion");
  if len(atts) != 0:
    print "Modifying DPFirmwareVersion with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DPFirmwareVersion configuration up to date.";

  Property.removeProperties(objid, 'properties',"DPFirmwareVersion");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPFirmwareVersion');
