from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DPVersion')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDPVersion");
  exportedObject.put("roleName", "WebSphereDPVersion");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpversion.versionimagefilelocation", objid, "versionImageFileLocation","DPVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpversion.versionnumber", objid, "versionNumber","DPVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpversion.usercomment", objid, "userComment","DPVersion");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dpversion.timecreatedinmanager", objid, "timeCreatedInManager","DPVersion");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DPVersion");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DPVersion');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DPVersion')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPVersion resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "versionImageFileLocation", roleProperties.optString("websphere.dpversion.versionimagefilelocation", None));
  Util.addIfNotNone(properties, "versionNumber", roleProperties.optString("websphere.dpversion.versionnumber", None));
  Util.addIfNotNone(properties, "userComment", roleProperties.optString("websphere.dpversion.usercomment", None));
  Util.addIfNotNone(properties, "timeCreatedInManager", roleProperties.optString("websphere.dpversion.timecreatedinmanager", None));
  print "Creating DPVersion with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DPVersion", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPVersion');

def update(objid,jsonobject):
  Util.pushPathElement('DPVersion')
  if not jsonobject.has("roleProperties"):
    raise Exception("DPVersion resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpversion.versionimagefilelocation", None), "versionImageFileLocation","DPVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpversion.versionnumber", None), "versionNumber","DPVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpversion.usercomment", None), "userComment","DPVersion");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dpversion.timecreatedinmanager", None), "timeCreatedInManager","DPVersion");
  if len(atts) != 0:
    print "Modifying DPVersion with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DPVersion configuration up to date.";

  Property.removeProperties(objid, 'properties',"DPVersion");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DPVersion');
