from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DRSConnectionPool')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDRSConnectionPool");
  exportedObject.put("roleName", "WebSphereDRSConnectionPool");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drsconnectionpool.size", objid, "size","DRSConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drsconnectionpool.poolconnections", objid, "poolConnections","DRSConnectionPool");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DRSConnectionPool');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DRSConnectionPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("DRSConnectionPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.drsconnectionpool.size", None));
  Util.addIfNotNone(properties, "poolConnections", roleProperties.optString("websphere.drsconnectionpool.poolconnections", None));
  print "Creating DRSConnectionPool with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DRSConnectionPool", parentid, properties);
  Util.popPathElement('DRSConnectionPool');

def update(objid,jsonobject):
  Util.pushPathElement('DRSConnectionPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("DRSConnectionPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drsconnectionpool.size", None), "size","DRSConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drsconnectionpool.poolconnections", None), "poolConnections","DRSConnectionPool");
  if len(atts) != 0:
    print "Modifying DRSConnectionPool with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DRSConnectionPool configuration up to date.";

  Util.popPathElement('DRSConnectionPool');
