from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DeployedObjectProxyConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDeployedObjectProxyConfig");
  exportedObject.put("roleName", "WebSphereDeployedObjectProxyConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deployedobjectproxyconfig.enableproxy", objid, "enableProxy","DeployedObjectProxyConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deployedobjectproxyconfig.deployedobjectconfigname", objid, "deployedObjectConfigName","DeployedObjectProxyConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.deployedobjectproxyconfig.transportprotocol", objid, "transportProtocol","DeployedObjectProxyConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"DeployedObjectProxyConfig");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DeployedObjectProxyConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DeployedObjectProxyConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedObjectProxyConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enableProxy", roleProperties.optString("websphere.deployedobjectproxyconfig.enableproxy", None));
  Util.addIfNotNone(properties, "deployedObjectConfigName", roleProperties.optString("websphere.deployedobjectproxyconfig.deployedobjectconfigname", None));
  Util.addIfNotNone(properties, "transportProtocol", roleProperties.optString("websphere.deployedobjectproxyconfig.transportprotocol", None));
  print "Creating DeployedObjectProxyConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DeployedObjectProxyConfig", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DeployedObjectProxyConfig');

def update(objid,jsonobject):
  Util.pushPathElement('DeployedObjectProxyConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("DeployedObjectProxyConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deployedobjectproxyconfig.enableproxy", None), "enableProxy","DeployedObjectProxyConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deployedobjectproxyconfig.deployedobjectconfigname", None), "deployedObjectConfigName","DeployedObjectProxyConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.deployedobjectproxyconfig.transportprotocol", None), "transportProtocol","DeployedObjectProxyConfig");
  if len(atts) != 0:
    print "Modifying DeployedObjectProxyConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DeployedObjectProxyConfig configuration up to date.";

  Property.removeProperties(objid, 'properties',"DeployedObjectProxyConfig");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DeployedObjectProxyConfig');
