from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DiagnosticProviderService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDiagnosticProviderService");
  exportedObject.put("roleName", "WebSphereDiagnosticProviderService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.diagnosticproviderservice.enable", objid, "enable","DiagnosticProviderService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.diagnosticproviderservice.startupstatecollectionspec", objid, "startupStateCollectionSpec","DiagnosticProviderService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid,respath,extraObjects,typeFolders,'properties',"DiagnosticProviderService" );

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DiagnosticProviderService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('DiagnosticProviderService')
  if not jsonobject.has("roleProperties"):
    raise Exception("DiagnosticProviderService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.diagnosticproviderservice.enable", None));
  Util.addIfNotNone(properties, "startupStateCollectionSpec", roleProperties.optString("websphere.diagnosticproviderservice.startupstatecollectionspec", None));
  print "Creating DiagnosticProviderService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DiagnosticProviderService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('DiagnosticProviderService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('DiagnosticProviderService')
  if not jsonobject.has("roleProperties"):
    raise Exception("DiagnosticProviderService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.diagnosticproviderservice.enable", None), "enable","DiagnosticProviderService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.diagnosticproviderservice.startupstatecollectionspec", None), "startupStateCollectionSpec","DiagnosticProviderService");
  if len(atts) != 0:
    print "Modifying DiagnosticProviderService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DiagnosticProviderService configuration up to date.";

  Property.removeProperties(objid, 'properties',"DiagnosticProviderService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('DiagnosticProviderService');
