from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.emitterfactoryprofile.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'EmitterFactoryProfile');

  containmentpath = "%(parentconpath)sEmitterFactoryProfile:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('EmitterFactoryProfile')

  name = Util.getRequiredAttribute(objid, "name", 'EmitterFactoryProfile');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEmitterFactoryProfile");
  exportedObject.put("roleName", "WebSphereEmitterFactoryProfile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.name", objid, "name","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.category", objid, "category","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.asynchronoustransmissionprofilejndiname", objid, "asynchronousTransmissionProfileJNDIName","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.filterfactoryjndiname", objid, "filterFactoryJNDIName","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.providertype", objid, "providerType","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.preferredsynchronizationmode", objid, "preferredSynchronizationMode","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.synchronoustransmissionprofilejndiname", objid, "synchronousTransmissionProfileJNDIName","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.jndiname", objid, "jndiName","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.filteringenabled", objid, "filteringEnabled","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.preferredtransactionmode", objid, "preferredTransactionMode","EmitterFactoryProfile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.emitterfactoryprofile.description", objid, "description","EmitterFactoryProfile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EmitterFactoryProfile');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not Util.isValidType("EmitterFactoryProfile", 1):
    return None;
  if not jsonobject.has("roleProperties"):
    raise Exception("EmitterFactoryProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.emitterfactoryprofile.name"):
    raise Exception("Resource role properties does not contain websphere.emitterfactoryprofile.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create EmitterFactoryProfile on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  if not Util.isValidType("EmitterFactoryProfile", 1):
    return None;
  Util.pushPathElement('EmitterFactoryProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EmitterFactoryProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.emitterfactoryprofile.name"):
    raise Exception("Resource role properties does not contain websphere.emitterfactoryprofile.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.emitterfactoryprofile.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.emitterfactoryprofile.category", None));
  Util.addIfNotNone(properties, "asynchronousTransmissionProfileJNDIName", roleProperties.optString("websphere.emitterfactoryprofile.asynchronoustransmissionprofilejndiname", None));
  Util.addIfNotNone(properties, "filterFactoryJNDIName", roleProperties.optString("websphere.emitterfactoryprofile.filterfactoryjndiname", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.emitterfactoryprofile.providertype", None));
  Util.addIfNotNone(properties, "preferredSynchronizationMode", roleProperties.optString("websphere.emitterfactoryprofile.preferredsynchronizationmode", None));
  Util.addIfNotNone(properties, "synchronousTransmissionProfileJNDIName", roleProperties.optString("websphere.emitterfactoryprofile.synchronoustransmissionprofilejndiname", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.emitterfactoryprofile.jndiname", None));
  Util.addIfNotNone(properties, "filteringEnabled", roleProperties.optString("websphere.emitterfactoryprofile.filteringenabled", None));
  Util.addIfNotNone(properties, "preferredTransactionMode", roleProperties.optString("websphere.emitterfactoryprofile.preferredtransactionmode", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.emitterfactoryprofile.description", None));
  print "Creating EmitterFactoryProfile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EmitterFactoryProfile", parentid, properties);
  Util.popPathElement('EmitterFactoryProfile');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('EmitterFactoryProfile')
  if not jsonobject.has("roleProperties"):
    raise Exception("EmitterFactoryProfile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.emitterfactoryprofile.name"):
    raise Exception("Resource role properties does not contain websphere.emitterfactoryprofile.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.name", None), "name","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.category", None), "category","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.asynchronoustransmissionprofilejndiname", None), "asynchronousTransmissionProfileJNDIName","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.filterfactoryjndiname", None), "filterFactoryJNDIName","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.providertype", None), "providerType","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.preferredsynchronizationmode", None), "preferredSynchronizationMode","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.synchronoustransmissionprofilejndiname", None), "synchronousTransmissionProfileJNDIName","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.jndiname", None), "jndiName","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.filteringenabled", None), "filteringEnabled","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.preferredtransactionmode", None), "preferredTransactionMode","EmitterFactoryProfile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.emitterfactoryprofile.description", None), "description","EmitterFactoryProfile");
  if len(atts) != 0:
    print "Modifying EmitterFactoryProfile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EmitterFactoryProfile configuration up to date.";

  Util.popPathElement('EmitterFactoryProfile');
