from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GSCMemberEndpoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGSCMemberEndpoint");
  exportedObject.put("roleName", "WebSphereGSCMemberEndpoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gscmemberendpoint.port", objid, "port","GSCMemberEndpoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gscmemberendpoint.host", objid, "host","GSCMemberEndpoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GSCMemberEndpoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GSCMemberEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("GSCMemberEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.gscmemberendpoint.port", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.gscmemberendpoint.host", None));
  print "Creating GSCMemberEndpoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GSCMemberEndpoint", parentid, properties);
  Util.popPathElement('GSCMemberEndpoint');

def update(objid,jsonobject):
  Util.pushPathElement('GSCMemberEndpoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("GSCMemberEndpoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gscmemberendpoint.port", None), "port","GSCMemberEndpoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gscmemberendpoint.host", None), "host","GSCMemberEndpoint");
  if len(atts) != 0:
    print "Modifying GSCMemberEndpoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GSCMemberEndpoint configuration up to date.";

  Util.popPathElement('GSCMemberEndpoint');
