from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GenericOutboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'GenericOutboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericOutboundChannel");
  exportedObject.put("roleName", "WebSphereGenericOutboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericoutboundchannel.name", objid, "name","GenericOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericoutboundchannel.typeid", objid, "typeID","GenericOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericoutboundchannel.configuri", objid, "configURI","GenericOutboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericoutboundchannel.jarfile", objid, "jarFile","GenericOutboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"GenericOutboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericOutboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.genericoutboundchannel.name", None));
  Util.addIfNotNone(properties, "typeID", roleProperties.optString("websphere.genericoutboundchannel.typeid", None));
  Util.addIfNotNone(properties, "configURI", roleProperties.optString("websphere.genericoutboundchannel.configuri", None));
  Util.addIfNotNone(properties, "jarFile", roleProperties.optString("websphere.genericoutboundchannel.jarfile", None));
  print "Creating GenericOutboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericOutboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericOutboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('GenericOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericoutboundchannel.name", None), "name","GenericOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericoutboundchannel.typeid", None), "typeID","GenericOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericoutboundchannel.configuri", None), "configURI","GenericOutboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericoutboundchannel.jarfile", None), "jarFile","GenericOutboundChannel");
  if len(atts) != 0:
    print "Modifying GenericOutboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericOutboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"GenericOutboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericOutboundChannel');
