from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HTTPTunnelOutboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'HTTPTunnelOutboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHTTPTunnelOutboundChannel");
  exportedObject.put("roleName", "WebSphereHTTPTunnelOutboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httptunneloutboundchannel.name", objid, "name","HTTPTunnelOutboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"HTTPTunnelOutboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPTunnelOutboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HTTPTunnelOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPTunnelOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.httptunneloutboundchannel.name", None));
  print "Creating HTTPTunnelOutboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HTTPTunnelOutboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HTTPTunnelOutboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('HTTPTunnelOutboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("HTTPTunnelOutboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.httptunneloutboundchannel.name", None), "name","HTTPTunnelOutboundChannel");
  if len(atts) != 0:
    print "Modifying HTTPTunnelOutboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HTTPTunnelOutboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"HTTPTunnelOutboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('HTTPTunnelOutboundChannel');
