from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JMSDestination')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJMSDestination");
  exportedObject.put("roleName", "WebSphereJMSDestination");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmsdestination.name", objid, "name","JMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmsdestination.description", objid, "description","JMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmsdestination.category", objid, "category","JMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmsdestination.providertype", objid, "providerType","JMSDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jmsdestination.jndiname", objid, "jndiName","JMSDestination");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JMSDestination');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JMSDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("JMSDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jmsdestination.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.jmsdestination.description", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.jmsdestination.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.jmsdestination.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.jmsdestination.jndiname", None));
  print "Creating JMSDestination with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JMSDestination", parentid, properties);
  Util.popPathElement('JMSDestination');

def update(objid,jsonobject):
  Util.pushPathElement('JMSDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("JMSDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsdestination.name", None), "name","JMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsdestination.description", None), "description","JMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsdestination.category", None), "category","JMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsdestination.providertype", None), "providerType","JMSDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jmsdestination.jndiname", None), "jndiName","JMSDestination");
  if len(atts) != 0:
    print "Modifying JMSDestination with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JMSDestination configuration up to date.";

  Util.popPathElement('JMSDestination');
