from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MiddlewareAppScript')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMiddlewareAppScript");
  exportedObject.put("roleName", "WebSphereMiddlewareAppScript");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareappscript.name", objid, "name","MiddlewareAppScript");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareappscript.type", objid, "type","MiddlewareAppScript");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MiddlewareAppScript");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MiddlewareAppScript');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MiddlewareAppScript')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareAppScript resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.middlewareappscript.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.middlewareappscript.type", None));
  print "Creating MiddlewareAppScript with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MiddlewareAppScript", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MiddlewareAppScript');

def update(objid,jsonobject):
  Util.pushPathElement('MiddlewareAppScript')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareAppScript resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareappscript.name", None), "name","MiddlewareAppScript");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareappscript.type", None), "type","MiddlewareAppScript");
  if len(atts) != 0:
    print "Modifying MiddlewareAppScript with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MiddlewareAppScript configuration up to date.";

  Property.removeProperties(objid, 'properties',"MiddlewareAppScript");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MiddlewareAppScript');
