from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.middlewaredescriptor.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MiddlewareDescriptor');

  containmentpath = "%(parentconpath)sMiddlewareDescriptor:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MiddlewareDescriptor')

  name = Util.getRequiredAttribute(objid, "name", 'MiddlewareDescriptor');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMiddlewareDescriptor");
  exportedObject.put("roleName", "WebSphereMiddlewareDescriptor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewaredescriptor.discoveryinterval", objid, "discoveryInterval","MiddlewareDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewaredescriptor.discoverysupported", objid, "discoverySupported","MiddlewareDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewaredescriptor.name", objid, "name","MiddlewareDescriptor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewaredescriptor.discoveryintervalunits", objid, "discoveryIntervalUnits","MiddlewareDescriptor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MiddlewareDescriptor');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareDescriptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.middlewaredescriptor.name"):
    raise Exception("Resource role properties does not contain websphere.middlewaredescriptor.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MiddlewareDescriptor on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MiddlewareDescriptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareDescriptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.middlewaredescriptor.name"):
    raise Exception("Resource role properties does not contain websphere.middlewaredescriptor.name!");

  properties = [];
  Util.addIfNotNone(properties, "discoveryInterval", roleProperties.optString("websphere.middlewaredescriptor.discoveryinterval", None));
  Util.addIfNotNone(properties, "discoverySupported", roleProperties.optString("websphere.middlewaredescriptor.discoverysupported", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.middlewaredescriptor.name", None));
  Util.addIfNotNone(properties, "discoveryIntervalUnits", roleProperties.optString("websphere.middlewaredescriptor.discoveryintervalunits", None));
  print "Creating MiddlewareDescriptor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MiddlewareDescriptor", parentid, properties);
  Util.popPathElement('MiddlewareDescriptor');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MiddlewareDescriptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareDescriptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.middlewaredescriptor.name"):
    raise Exception("Resource role properties does not contain websphere.middlewaredescriptor.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewaredescriptor.discoveryinterval", None), "discoveryInterval","MiddlewareDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewaredescriptor.discoverysupported", None), "discoverySupported","MiddlewareDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewaredescriptor.name", None), "name","MiddlewareDescriptor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewaredescriptor.discoveryintervalunits", None), "discoveryIntervalUnits","MiddlewareDescriptor");
  if len(atts) != 0:
    print "Modifying MiddlewareDescriptor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MiddlewareDescriptor configuration up to date.";

  Util.popPathElement('MiddlewareDescriptor');
