from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MultiBrokerRoutingEntry')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMultiBrokerRoutingEntry");
  exportedObject.put("roleName", "WebSphereMultiBrokerRoutingEntry");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.multibrokerroutingentry.brokername", objid, "brokerName","MultiBrokerRoutingEntry");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MultiBrokerRoutingEntry');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MultiBrokerRoutingEntry')
  if not jsonobject.has("roleProperties"):
    raise Exception("MultiBrokerRoutingEntry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "brokerName", roleProperties.optString("websphere.multibrokerroutingentry.brokername", None));
  print "Creating MultiBrokerRoutingEntry with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MultiBrokerRoutingEntry", parentid, properties);
  Util.popPathElement('MultiBrokerRoutingEntry');

def update(objid,jsonobject):
  Util.pushPathElement('MultiBrokerRoutingEntry')
  if not jsonobject.has("roleProperties"):
    raise Exception("MultiBrokerRoutingEntry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.multibrokerroutingentry.brokername", None), "brokerName","MultiBrokerRoutingEntry");
  if len(atts) != 0:
    print "Modifying MultiBrokerRoutingEntry with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MultiBrokerRoutingEntry configuration up to date.";

  Util.popPathElement('MultiBrokerRoutingEntry');
