from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RecoveryLog')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRecoveryLog");
  exportedObject.put("roleName", "WebSphereRecoveryLog");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.recoverylog.transactionlogdirectory", objid, "transactionLogDirectory","RecoveryLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.recoverylog.compensationlogfilesize", objid, "compensationLogFileSize","RecoveryLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.recoverylog.compensationlogdirectory", objid, "compensationLogDirectory","RecoveryLog");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RecoveryLog');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RecoveryLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("RecoveryLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "transactionLogDirectory", roleProperties.optString("websphere.recoverylog.transactionlogdirectory", None));
  Util.addIfNotNone(properties, "compensationLogFileSize", roleProperties.optString("websphere.recoverylog.compensationlogfilesize", None));
  Util.addIfNotNone(properties, "compensationLogDirectory", roleProperties.optString("websphere.recoverylog.compensationlogdirectory", None));
  print "Creating RecoveryLog with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RecoveryLog", parentid, properties);
  Util.popPathElement('RecoveryLog');

def update(objid,jsonobject):
  Util.pushPathElement('RecoveryLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("RecoveryLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.recoverylog.transactionlogdirectory", None), "transactionLogDirectory","RecoveryLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.recoverylog.compensationlogfilesize", None), "compensationLogFileSize","RecoveryLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.recoverylog.compensationlogdirectory", None), "compensationLogDirectory","RecoveryLog");
  if len(atts) != 0:
    print "Modifying RecoveryLog with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RecoveryLog configuration up to date.";

  Util.popPathElement('RecoveryLog');
