from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBContextInfo import SIBContextInfo;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBDestinationForeign')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBDestinationForeign");
  exportedObject.put("roleName", "WebSphereSIBDestinationForeign");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.uuid", objid, "uuid","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.defaultpriority", objid, "defaultPriority","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.reliability", objid, "reliability","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.maxreliability", objid, "maxReliability","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.instancetype", objid, "instanceType","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.sendallowed", objid, "sendAllowed","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.identifier", objid, "identifier","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.bus", objid, "bus","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.overrideofqosbyproducerallowed", objid, "overrideOfQOSByProducerAllowed","SIBDestinationForeign");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationforeign.description", objid, "description","SIBDestinationForeign");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  contextInfos = Util.parseConfigIdListAttribute(objid, 'contextInfo', 'SIBDestinationForeign');
  for contextInfo in contextInfos:
    if len(contextInfo) > 0:
      returndict = Util.createTypeFolder(respath, "SIBContextInfo", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SIBContextInfo._export(contextInfo, currespath, "SIBContextInfo%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBDestinationForeign');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBDestinationForeign')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationForeign resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibdestinationforeign.uuid", None));
  Util.addIfNotNone(properties, "defaultPriority", roleProperties.optString("websphere.sibdestinationforeign.defaultpriority", None));
  Util.addIfNotNone(properties, "reliability", roleProperties.optString("websphere.sibdestinationforeign.reliability", None));
  Util.addIfNotNone(properties, "maxReliability", roleProperties.optString("websphere.sibdestinationforeign.maxreliability", None));
  Util.addIfNotNone(properties, "instanceType", roleProperties.optString("websphere.sibdestinationforeign.instancetype", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.sibdestinationforeign.sendallowed", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibdestinationforeign.identifier", None));
  Util.addIfNotNone(properties, "bus", roleProperties.optString("websphere.sibdestinationforeign.bus", None));
  Util.addIfNotNone(properties, "overrideOfQOSByProducerAllowed", roleProperties.optString("websphere.sibdestinationforeign.overrideofqosbyproducerallowed", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibdestinationforeign.description", None));
  print "Creating SIBDestinationForeign with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBDestinationForeign", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBContextInfo":
        SIBContextInfo.create(objid, curjsonobject);

  Util.popPathElement('SIBDestinationForeign');

def update(objid,jsonobject):
  Util.pushPathElement('SIBDestinationForeign')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationForeign resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.uuid", None), "uuid","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.defaultpriority", None), "defaultPriority","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.reliability", None), "reliability","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.maxreliability", None), "maxReliability","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.instancetype", None), "instanceType","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.sendallowed", None), "sendAllowed","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.identifier", None), "identifier","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.bus", None), "bus","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.overrideofqosbyproducerallowed", None), "overrideOfQOSByProducerAllowed","SIBDestinationForeign");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationforeign.description", None), "description","SIBDestinationForeign");
  if len(atts) != 0:
    print "Modifying SIBDestinationForeign with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBDestinationForeign configuration up to date.";

  contextInfos = Util.parseConfigIdListAttribute(objid, 'contextInfo', 'SIBQueue');
  for contextInfo in contextInfos:
    if len(contextInfo) > 0:
      Util.remove(contextInfo);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBContextInfo":
        SIBContextInfo.create(objid, curjsonobject);

  Util.popPathElement('SIBDestinationForeign');

def getSIBDestinationForeigns(objid):
  sibDestinationForeigns = Util.getAssociatedObjects(objid, "SIBDestinationForeign");
  return sibDestinationForeigns;       
