from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBJMSQueue')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBJMSQueue");
  exportedObject.put("roleName", "WebSphereSIBJMSQueue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.name", objid, "name","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.category", objid, "category","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.queuename", objid, "queueName","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.providertype", objid, "providerType","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.jndiname", objid, "jndiName","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.readahead", objid, "readAhead","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.nonpersistentmapping", objid, "nonPersistentMapping","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.priority", objid, "priority","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.deliverymode", objid, "deliveryMode","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.description", objid, "description","SIBJMSQueue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmsqueue.timetolive", objid, "timeToLive","SIBJMSQueue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBJMSQueue');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBJMSQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibjmsqueue.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.sibjmsqueue.category", None));
  Util.addIfNotNone(properties, "queueName", roleProperties.optString("websphere.sibjmsqueue.queuename", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.sibjmsqueue.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.sibjmsqueue.jndiname", None));
  Util.addIfNotNone(properties, "readAhead", roleProperties.optString("websphere.sibjmsqueue.readahead", None));
  Util.addIfNotNone(properties, "nonPersistentMapping", roleProperties.optString("websphere.sibjmsqueue.nonpersistentmapping", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.sibjmsqueue.priority", None));
  Util.addIfNotNone(properties, "deliveryMode", roleProperties.optString("websphere.sibjmsqueue.deliverymode", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibjmsqueue.description", None));
  Util.addIfNotNone(properties, "timeToLive", roleProperties.optString("websphere.sibjmsqueue.timetolive", None));
  print "Creating SIBJMSQueue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBJMSQueue", parentid, properties);
  Util.popPathElement('SIBJMSQueue');

def update(objid,jsonobject):
  Util.pushPathElement('SIBJMSQueue')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSQueue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.name", None), "name","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.category", None), "category","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.queuename", None), "queueName","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.providertype", None), "providerType","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.jndiname", None), "jndiName","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.readahead", None), "readAhead","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.nonpersistentmapping", None), "nonPersistentMapping","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.priority", None), "priority","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.deliverymode", None), "deliveryMode","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.description", None), "description","SIBJMSQueue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmsqueue.timetolive", None), "timeToLive","SIBJMSQueue");
  if len(atts) != 0:
    print "Modifying SIBJMSQueue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBJMSQueue configuration up to date.";

  Util.popPathElement('SIBJMSQueue');
