from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSWSDLLocation')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSWSDLLocation");
  exportedObject.put("roleName", "WebSphereSIBWSWSDLLocation");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwswsdllocation.wsdlservicenamespace", objid, "WSDLServiceNamespace","SIBWSWSDLLocation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwswsdllocation.wsdluddireference", objid, "WSDLUDDIReference","SIBWSWSDLLocation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwswsdllocation.wsdllocation", objid, "WSDLLocation","SIBWSWSDLLocation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwswsdllocation.wsdllocationkind", objid, "WSDLLocationKind","SIBWSWSDLLocation");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwswsdllocation.wsdlservicename", objid, "WSDLServiceName","SIBWSWSDLLocation");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSWSDLLocation');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSWSDLLocation')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSWSDLLocation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "WSDLServiceNamespace", roleProperties.optString("websphere.sibwswsdllocation.wsdlservicenamespace", None));
  Util.addIfNotNone(properties, "WSDLUDDIReference", roleProperties.optString("websphere.sibwswsdllocation.wsdluddireference", None));
  Util.addIfNotNone(properties, "WSDLLocation", roleProperties.optString("websphere.sibwswsdllocation.wsdllocation", None));
  Util.addIfNotNone(properties, "WSDLLocationKind", roleProperties.optString("websphere.sibwswsdllocation.wsdllocationkind", None));
  Util.addIfNotNone(properties, "WSDLServiceName", roleProperties.optString("websphere.sibwswsdllocation.wsdlservicename", None));
  print "Creating SIBWSWSDLLocation with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSWSDLLocation", parentid, properties);
  Util.popPathElement('SIBWSWSDLLocation');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSWSDLLocation')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSWSDLLocation resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwswsdllocation.wsdlservicenamespace", None), "WSDLServiceNamespace","SIBWSWSDLLocation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwswsdllocation.wsdluddireference", None), "WSDLUDDIReference","SIBWSWSDLLocation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwswsdllocation.wsdllocation", None), "WSDLLocation","SIBWSWSDLLocation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwswsdllocation.wsdllocationkind", None), "WSDLLocationKind","SIBWSWSDLLocation");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwswsdllocation.wsdlservicename", None), "WSDLServiceName","SIBWSWSDLLocation");
  if len(atts) != 0:
    print "Modifying SIBWSWSDLLocation with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSWSDLLocation configuration up to date.";

  Util.popPathElement('SIBWSWSDLLocation');
