from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ManagementScope import ManagementScope
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecurityDomainMember')

  attName = Util.getRequiredAttribute(objid, "name", 'SecurityDomainMember');
  if attName is not None and len(attName) > 0:
    name = attName;

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecurityDomainMember");
  exportedObject.put("roleName", "WebSphereSecurityDomainMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitydomainmember.name", objid, "name","SecurityDomainMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitydomainmember.resourcename", objid, "resourceName","SecurityDomainMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitydomainmember.resourcetype", objid, "resourceType","SecurityDomainMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securitydomainmember.description", objid, "description","SecurityDomainMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SecurityDomainMember");

  i = 0;
  members = Util.parseConfigIdListAttribute(objid, 'members',"SecurityDomainMember");
  for member in members:
    if len(member) > 0:
      returndict = Util.createTypeFolder(respath, "SecurityDomainMember", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SecurityDomainMember._export(member, currespath, "SecurityDomainMember%s" % i));
      i = i + 1;

  i = 0;
  scopes = Util.parseConfigIdListAttribute(objid, 'memberScopes',"SecurityDomainMember");
  for scope in scopes:
    if len(scope) > 0:
      returndict = Util.createTypeFolder(respath, "ManagementScope", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ManagementScope._export(scope, currespath, "ManagementScope%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecurityDomainMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecurityDomainMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityDomainMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNoneOrEmpty(properties, "name", roleProperties.optString("websphere.securitydomainmember.name", None));
  Util.addIfNotNone(properties, "resourceName", roleProperties.optString("websphere.securitydomainmember.resourcename", None));
  Util.addIfNotNone(properties, "resourceType", roleProperties.optString("websphere.securitydomainmember.resourcetype", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.securitydomainmember.description", None));
  print "Creating SecurityDomainMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecurityDomainMember", parentid, properties);

  members = Util.parseConfigIdListAttribute(objid, 'members',"SecurityDomain");
  for member in members:
    if len(member) > 0:
      Util.remove(member);

  scopes = Util.parseConfigIdListAttribute(objid, 'memberScopes',"SecurityDomain");
  for scope in scopes:
    if len(scope) > 0:
      Util.remove(scope);

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereSecurityDomainMember":
          SecurityDomainMember.create(objid, curjsonobject);
        elif currole == "WebSphereManagementScope":
          ManagementScope.create(objid, curjsonobject);

  Util.popPathElement('SecurityDomainMember');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('SecurityDomainMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityDomainMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitydomainmember.name", None), "name","SecurityDomainMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitydomainmember.resourcename", None), "resourceName","SecurityDomainMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitydomainmember.resourcetype", None), "resourceType","SecurityDomainMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securitydomainmember.description", None), "description","SecurityDomainMember");
  if len(atts) != 0:
    print "Modifying SecurityDomainMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "SecurityDomainMember configuration up to date.";

  Property.removeProperties(objid, 'properties',"SecurityDomainMember");

  members = Util.parseConfigIdListAttribute(objid, 'members',"SecurityDomain");
  for member in members:
    if len(member) > 0:
      Util.remove(member);

  scopes = Util.parseConfigIdListAttribute(objid, 'memberScopes',"SecurityDomain");
  for scope in scopes:
    if len(scope) > 0:
      Util.remove(scope);

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if propertyObject == 0:
        if currole == "WebSphereSecurityDomainMember":
          SecurityDomainMember.create(objid, curjsonobject);
        elif currole == "WebSphereManagementScope":
          ManagementScope.create(objid, curjsonobject);

  Util.popPathElement('SecurityDomainMember');
