from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ThreadPool')

  name = Util.getOptionalAttribute(objid, 'name',"ThreadPool");
  if ((name is None) or (len(name) == 0)):
    name = "ThreadPool";
  
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereThreadPool");
  exportedObject.put("roleName", "WebSphereThreadPool");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.threadpool.maximumsize", objid, "maximumSize","ThreadPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.threadpool.name", objid, "name","ThreadPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.threadpool.minimumsize", objid, "minimumSize","ThreadPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.threadpool.inactivitytimeout", objid, "inactivityTimeout","ThreadPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.threadpool.description", objid, "description","ThreadPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.threadpool.isgrowable", objid, "isGrowable","ThreadPool");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'customProperties',"ThreadPool");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ThreadPool');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ThreadPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("ThreadPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maximumSize", roleProperties.optString("websphere.threadpool.maximumsize", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.threadpool.name", None));
  Util.addIfNotNone(properties, "minimumSize", roleProperties.optString("websphere.threadpool.minimumsize", None));
  Util.addIfNotNone(properties, "inactivityTimeout", roleProperties.optString("websphere.threadpool.inactivitytimeout", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.threadpool.description", None));
  Util.addIfNotNone(properties, "isGrowable", roleProperties.optString("websphere.threadpool.isgrowable", None));
  print "Creating ThreadPool with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ThreadPool", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ThreadPool');

def update(objid,jsonobject):
  Util.pushPathElement('ThreadPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("ThreadPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.threadpool.maximumsize", None), "maximumSize","ThreadPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.threadpool.name", None), "name","ThreadPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.threadpool.minimumsize", None), "minimumSize","ThreadPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.threadpool.inactivitytimeout", None), "inactivityTimeout","ThreadPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.threadpool.description", None), "description","ThreadPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.threadpool.isgrowable", None), "isGrowable","ThreadPool");
  if len(atts) != 0:
    print "Modifying ThreadPool with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ThreadPool configuration up to date.";

  Property.removeProperties(objid, 'customProperties',"ThreadPool");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ThreadPool');
