from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CheckpointDocument')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCheckpointDocument");
  exportedObject.put("roleName", "WebSphereCheckpointDocument");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.checkpointdocument.name", objid, "name","CheckpointDocument");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.checkpointdocument.uri", objid, "URI","CheckpointDocument");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CheckpointDocument');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CheckpointDocument')
  if not jsonobject.has("roleProperties"):
    raise Exception("CheckpointDocument resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.checkpointdocument.name", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.checkpointdocument.uri", None));
  print "Creating CheckpointDocument with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CheckpointDocument", parentid, properties);
  Util.popPathElement('CheckpointDocument');

def update(objid,jsonobject):
  Util.pushPathElement('CheckpointDocument')
  if not jsonobject.has("roleProperties"):
    raise Exception("CheckpointDocument resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.checkpointdocument.name", None), "name","CheckpointDocument");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.checkpointdocument.uri", None), "URI","CheckpointDocument");
  if len(atts) != 0:
    print "Modifying CheckpointDocument with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CheckpointDocument configuration up to date.";

  Util.popPathElement('CheckpointDocument');
