from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.httpresponseheaderactionref.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HTTPResponseHeaderActionRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "name", "HTTPResponseHeaderAction");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered HTTPResponseHeaderActionRef");
  exportedObject.put("roleName", "WebSphereHTTPResponseHeaderActionRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.httpresponseheaderactionref.name", objid, "name","HTTPResponseHeaderAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HTTPResponseHeaderActionRef');
  return result;


def doImport(parentid, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("WebSphereHTTPResponseHeaderActionRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.httpresponseheaderactionref.name"):
    raise Exception("Resource role properties does not contain websphere.httpresponseheaderactionref.name!");

  httpResponseHeaderActionRefName = roleProperties.optString("websphere.httpresponseheaderactionref.name", None);
  serverName = parentid.split('/servers/')[1].split('|')[0];
  if serverName == None or len(serverName) == 0:
    clusterName = parentid.split('/clusters/')[1].split('|')[0];
    containmentPath = "/ServerCluster:" + clusterName + "/ProxyVirtualHostConfig:/HTTPResponseHeaderAction:" + httpResponseHeaderActionRefName + "/";
  else:
    containmentPath = "/Server:" + serverName + "/ProxyVirtualHostConfig:/HTTPResponseHeaderAction:" + httpResponseHeaderActionRefName + "/";
  httpResponseHeaderAction = Util.getid(containmentPath);
  if httpResponseHeaderAction == None or len(httpResponseHeaderAction) == 0:
      raise Exception("Could not determine the HTTP Response Header Action for HTTPResponseHeaderActionRef " + httpResponseHeaderActionRefName + ". Searched on containment path " + containmentPath + ".");

  Util.pushPathElement("Server");
  Util.pushPathElement("ProxyVirtualHostConfig");
  Util.pushPathElement("ProxyRuleExpression");
  Util.modify(parentid, [['enabledProxyActions', httpResponseHeaderAction]]);
  Util.popPathElement("ProxyRuleExpression");
  Util.popPathElement("ProxyVirtualHostConfig");
  Util.popPathElement("Server");
