from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ParamValue')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereParamValue");
  exportedObject.put("roleName", "WebSphereParamValue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.paramvalue.name", objid, "name","ParamValue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.paramvalue.description", objid, "description","ParamValue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.paramvalue.value", objid, "value","ParamValue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'ParamValue');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ParamValue');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ParamValue')
  if not jsonobject.has("roleProperties"):
    raise Exception("ParamValue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.paramvalue.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.paramvalue.description", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.paramvalue.value", None));
  print "Creating ParamValue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ParamValue", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('ParamValue');

def update(objid,jsonobject):
  Util.pushPathElement('ParamValue')
  if not jsonobject.has("roleProperties"):
    raise Exception("ParamValue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.paramvalue.name", None), "name","ParamValue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.paramvalue.description", None), "description","ParamValue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.paramvalue.value", None), "value","ParamValue");
  if len(atts) != 0:
    print "Modifying ParamValue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ParamValue configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'ParamValue');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('ParamValue');
