from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WAS40ConnectionPool')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWAS40ConnectionPool");
  exportedObject.put("roleName", "WebSphereWAS40ConnectionPool");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.was40connectionpool.minimumpoolsize", objid, "minimumPoolSize","WAS40ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.was40connectionpool.connectiontimeout", objid, "connectionTimeout","WAS40ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.was40connectionpool.idletimeout", objid, "idleTimeout","WAS40ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.was40connectionpool.maximumpoolsize", objid, "maximumPoolSize","WAS40ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.was40connectionpool.disableautoconnectioncleanup", objid, "disableAutoConnectionCleanup","WAS40ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.was40connectionpool.statementcachesize", objid, "statementCacheSize","WAS40ConnectionPool");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.was40connectionpool.orphantimeout", objid, "orphanTimeout","WAS40ConnectionPool");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WAS40ConnectionPool');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WAS40ConnectionPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("WAS40ConnectionPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "minimumPoolSize", roleProperties.optString("websphere.was40connectionpool.minimumpoolsize", None));
  Util.addIfNotNone(properties, "connectionTimeout", roleProperties.optString("websphere.was40connectionpool.connectiontimeout", None));
  Util.addIfNotNone(properties, "idleTimeout", roleProperties.optString("websphere.was40connectionpool.idletimeout", None));
  Util.addIfNotNone(properties, "maximumPoolSize", roleProperties.optString("websphere.was40connectionpool.maximumpoolsize", None));
  Util.addIfNotNone(properties, "disableAutoConnectionCleanup", roleProperties.optString("websphere.was40connectionpool.disableautoconnectioncleanup", None));
  Util.addIfNotNone(properties, "statementCacheSize", roleProperties.optString("websphere.was40connectionpool.statementcachesize", None));
  Util.addIfNotNone(properties, "orphanTimeout", roleProperties.optString("websphere.was40connectionpool.orphantimeout", None));
  print "Creating WAS40ConnectionPool with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WAS40ConnectionPool", parentid, properties);
  Util.popPathElement('WAS40ConnectionPool');

def update(objid,jsonobject):
  Util.pushPathElement('WAS40ConnectionPool')
  if not jsonobject.has("roleProperties"):
    raise Exception("WAS40ConnectionPool resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.was40connectionpool.minimumpoolsize", None), "minimumPoolSize","WAS40ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.was40connectionpool.connectiontimeout", None), "connectionTimeout","WAS40ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.was40connectionpool.idletimeout", None), "idleTimeout","WAS40ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.was40connectionpool.maximumpoolsize", None), "maximumPoolSize","WAS40ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.was40connectionpool.disableautoconnectioncleanup", None), "disableAutoConnectionCleanup","WAS40ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.was40connectionpool.statementcachesize", None), "statementCacheSize","WAS40ConnectionPool");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.was40connectionpool.orphantimeout", None), "orphanTimeout","WAS40ConnectionPool");
  if len(atts) != 0:
    print "Modifying WAS40ConnectionPool with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WAS40ConnectionPool configuration up to date.";

  Util.popPathElement('WAS40ConnectionPool');
