from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CustomElasticityAction')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCustomElasticityAction");
  exportedObject.put("roleName", "WebSphereCustomElasticityAction");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customelasticityaction.actionname", objid, "actionName","CustomElasticityAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customelasticityaction.actiontype", objid, "actionType","CustomElasticityAction");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customelasticityaction.stepnum", objid, "stepNum","CustomElasticityAction");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CustomElasticityAction');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CustomElasticityAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomElasticityAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "actionName", roleProperties.optString("websphere.customelasticityaction.actionname", None));
  Util.addIfNotNone(properties, "actionType", roleProperties.optString("websphere.customelasticityaction.actiontype", None));
  Util.addIfNotNone(properties, "stepNum", roleProperties.optString("websphere.customelasticityaction.stepnum", None));
  print "Creating CustomElasticityAction with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CustomElasticityAction", parentid, properties);
  Util.popPathElement('CustomElasticityAction');

def update(objid,jsonobject):
  Util.pushPathElement('CustomElasticityAction')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomElasticityAction resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customelasticityaction.actionname", None), "actionName","CustomElasticityAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customelasticityaction.actiontype", None), "actionType","CustomElasticityAction");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customelasticityaction.stepnum", None), "stepNum","CustomElasticityAction");
  if len(atts) != 0:
    print "Modifying CustomElasticityAction with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CustomElasticityAction configuration up to date.";

  Util.popPathElement('CustomElasticityAction');
