from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SSLConfigRef import SSLConfigRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DynamicReload')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDynamicReload");
  exportedObject.put("roleName", "WebSphereDynamicReload");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allrolebasedauthorization", objid, "allRoleBasedAuthorization","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allauthdataentries", objid, "allAuthDataEntries","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allproperties", objid, "allProperties","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allauthmechanisms", objid, "allAuthMechanisms","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.alluserregistries", objid, "allUserRegistries","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.alljaasentries", objid, "allJAASEntries","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allsslconfiggroups", objid, "allSSLConfigGroups","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allelements", objid, "allElements","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allcaclients", objid, "allCAClients","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allcertificates", objid, "allCertificates","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allauthorizationproviders", objid, "allAuthorizationProviders","DynamicReload");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicreload.allsslconfigs", objid, "allSSLConfigs","DynamicReload");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  sslConfigs = Util.parseConfigIdListAttribute(objid, 'sslConfigs', "DynamicReload");
  for sslConfig in sslConfigs:
    if len(sslConfig) > 0:
      returndict = Util.createTypeFolder(respath, "SSLConfigRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SSLConfigRef._export(sslConfig, currespath, "SSLConfigRef%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DynamicReload');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DynamicReload')
  if not jsonobject.has("roleProperties"):
    raise Exception("DynamicReload resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "allRoleBasedAuthorization", roleProperties.optString("websphere.dynamicreload.allrolebasedauthorization", None));
  Util.addIfNotNone(properties, "allAuthDataEntries", roleProperties.optString("websphere.dynamicreload.allauthdataentries", None));
  Util.addIfNotNone(properties, "allProperties", roleProperties.optString("websphere.dynamicreload.allproperties", None));
  Util.addIfNotNone(properties, "allAuthMechanisms", roleProperties.optString("websphere.dynamicreload.allauthmechanisms", None));
  Util.addIfNotNone(properties, "allUserRegistries", roleProperties.optString("websphere.dynamicreload.alluserregistries", None));
  Util.addIfNotNone(properties, "allJAASEntries", roleProperties.optString("websphere.dynamicreload.alljaasentries", None));
  Util.addIfNotNone(properties, "allSSLConfigGroups", roleProperties.optString("websphere.dynamicreload.allsslconfiggroups", None));
  Util.addIfNotNone(properties, "allElements", roleProperties.optString("websphere.dynamicreload.allelements", None));
  Util.addIfNotNone(properties, "allCAClients", roleProperties.optString("websphere.dynamicreload.allcaclients", None));
  Util.addIfNotNone(properties, "allCertificates", roleProperties.optString("websphere.dynamicreload.allcertificates", None));
  Util.addIfNotNone(properties, "allAuthorizationProviders", roleProperties.optString("websphere.dynamicreload.allauthorizationproviders", None));
  Util.addIfNotNone(properties, "allSSLConfigs", roleProperties.optString("websphere.dynamicreload.allsslconfigs", None));
  print "Creating DynamicReload with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DynamicReload", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSSLConfigRef":
        SSLConfigRef.create(objid, curjsonobject, "sslConfigs");
  Util.popPathElement('DynamicReload');

def update(objid,jsonobject):
  Util.pushPathElement('DynamicReload')
  if not jsonobject.has("roleProperties"):
    raise Exception("DynamicReload resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allrolebasedauthorization", None), "allRoleBasedAuthorization","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allauthdataentries", None), "allAuthDataEntries","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allproperties", None), "allProperties","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allauthmechanisms", None), "allAuthMechanisms","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.alluserregistries", None), "allUserRegistries","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.alljaasentries", None), "allJAASEntries","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allsslconfiggroups", None), "allSSLConfigGroups","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allelements", None), "allElements","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allcaclients", None), "allCAClients","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allcertificates", None), "allCertificates","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allauthorizationproviders", None), "allAuthorizationProviders","DynamicReload");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicreload.allsslconfigs", None), "allSSLConfigs","DynamicReload");
  if len(atts) != 0:
    print "Modifying DynamicReload with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DynamicReload configuration up to date.";

  Util.unsetAttribute(objid, "sslConfigs", "DynamicReload");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSSLConfigRef":
        SSLConfigRef.create(objid, curjsonobject, "sslConfigs");


  Util.popPathElement('DynamicReload');
