from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PercentileResponseTimeGoal')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePercentileResponseTimeGoal");
  exportedObject.put("roleName", "WebSpherePercentileResponseTimeGoal");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.timeperiodvalue", objid, "timePeriodValue","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.violationenabled", objid, "violationEnabled","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.goaldeltavalue", objid, "goalDeltaValue","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.goalpercent", objid, "goalPercent","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.timeperiodvalueunits", objid, "timePeriodValueUnits","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.goalvalueunits", objid, "goalValueUnits","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.goaldeltapercent", objid, "goalDeltaPercent","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.goalvalue", objid, "goalValue","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.importance", objid, "importance","PercentileResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.percentileresponsetimegoal.goaldeltavalueunits", objid, "goalDeltaValueUnits","PercentileResponseTimeGoal");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PercentileResponseTimeGoal');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PercentileResponseTimeGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("PercentileResponseTimeGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "timePeriodValue", roleProperties.optString("websphere.percentileresponsetimegoal.timeperiodvalue", None));
  Util.addIfNotNone(properties, "violationEnabled", roleProperties.optString("websphere.percentileresponsetimegoal.violationenabled", None));
  Util.addIfNotNone(properties, "goalDeltaValue", roleProperties.optString("websphere.percentileresponsetimegoal.goaldeltavalue", None));
  Util.addIfNotNone(properties, "goalPercent", roleProperties.optString("websphere.percentileresponsetimegoal.goalpercent", None));
  Util.addIfNotNone(properties, "timePeriodValueUnits", roleProperties.optString("websphere.percentileresponsetimegoal.timeperiodvalueunits", None));
  Util.addIfNotNone(properties, "goalValueUnits", roleProperties.optString("websphere.percentileresponsetimegoal.goalvalueunits", None));
  Util.addIfNotNone(properties, "goalDeltaPercent", roleProperties.optString("websphere.percentileresponsetimegoal.goaldeltapercent", None));
  Util.addIfNotNone(properties, "goalValue", roleProperties.optString("websphere.percentileresponsetimegoal.goalvalue", None));
  Util.addIfNotNone(properties, "importance", roleProperties.optString("websphere.percentileresponsetimegoal.importance", None));
  Util.addIfNotNone(properties, "goalDeltaValueUnits", roleProperties.optString("websphere.percentileresponsetimegoal.goaldeltavalueunits", None));
  print "Creating PercentileResponseTimeGoal with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PercentileResponseTimeGoal", parentid, properties);
  Util.popPathElement('PercentileResponseTimeGoal');

def update(objid,jsonobject):
  Util.pushPathElement('PercentileResponseTimeGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("PercentileResponseTimeGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.timeperiodvalue", None), "timePeriodValue","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.violationenabled", None), "violationEnabled","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.goaldeltavalue", None), "goalDeltaValue","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.goalpercent", None), "goalPercent","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.timeperiodvalueunits", None), "timePeriodValueUnits","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.goalvalueunits", None), "goalValueUnits","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.goaldeltapercent", None), "goalDeltaPercent","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.goalvalue", None), "goalValue","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.importance", None), "importance","PercentileResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.percentileresponsetimegoal.goaldeltavalueunits", None), "goalDeltaValueUnits","PercentileResponseTimeGoal");
  if len(atts) != 0:
    print "Modifying PercentileResponseTimeGoal with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PercentileResponseTimeGoal configuration up to date.";

  Util.popPathElement('PercentileResponseTimeGoal');
