from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from ServiceLog import ServiceLog
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RASLoggingService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRASLoggingService");
  exportedObject.put("roleName", "WebSphereRASLoggingService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rasloggingservice.enable", objid, "enable","RASLoggingService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rasloggingservice.suppressstacktraces", objid, "suppressStackTraces","RASLoggingService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rasloggingservice.messagefilterlevel", objid, "messageFilterLevel","RASLoggingService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rasloggingservice.enablecorrelationid", objid, "enableCorrelationId","RASLoggingService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"RASLoggingService");

  serviceLog = Util.getOptionalAttribute(objid, 'serviceLog', 'RASLoggingService');
  if serviceLog is not None and len(serviceLog) > 0:
    returndict = Util.createTypeFolder(respath, "ServiceLog", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ServiceLog._export(serviceLog, currespath, 'ServiceLog'));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RASLoggingService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('RASLoggingService')
  if not jsonobject.has("roleProperties"):
    raise Exception("RASLoggingService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.rasloggingservice.enable", None));
  Util.addIfNotNone(properties, "suppressStackTraces", roleProperties.optString("websphere.rasloggingservice.suppressstacktraces", None));
  Util.addIfNotNone(properties, "messageFilterLevel", roleProperties.optString("websphere.rasloggingservice.messagefilterlevel", None));
  Util.addIfNotNone(properties, "enableCorrelationId", roleProperties.optString("websphere.rasloggingservice.enablecorrelationid", None));
  print "Creating RASLoggingService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RASLoggingService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereServiceLog":
          ServiceLog.create(objid, curjsonobject);
  Util.popPathElement('RASLoggingService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('RASLoggingService')
  if not jsonobject.has("roleProperties"):
    raise Exception("RASLoggingService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rasloggingservice.enable", None), "enable","RASLoggingService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rasloggingservice.suppressstacktraces", None), "suppressStackTraces","RASLoggingService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rasloggingservice.messagefilterlevel", None), "messageFilterLevel","RASLoggingService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rasloggingservice.enablecorrelationid", None), "enableCorrelationId","RASLoggingService");
  if len(atts) != 0:
    print "Modifying RASLoggingService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RASLoggingService configuration up to date.";

  Property.removeProperties(objid,'properties',"RASLoggingService");

  serviceLog = Util.getOptionalAttribute(objid, 'serviceLog', 'RASLoggingService');
  if serviceLog is not None and len(serviceLog) > 0:
    Util.remove(serviceLog);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereServiceLog":
          ServiceLog.create(objid, curjsonobject);

  Util.popPathElement('RASLoggingService');
