from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBPermittedChain')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBPermittedChain");
  exportedObject.put("roleName", "WebSphereSIBPermittedChain");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpermittedchain.name", objid, "name","SIBPermittedChain");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBPermittedChain');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBPermittedChain')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPermittedChain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibpermittedchain.name", None));
  print "Creating SIBPermittedChain with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBPermittedChain", parentid, properties);
  Util.popPathElement('SIBPermittedChain');

def update(objid,jsonobject):
  Util.pushPathElement('SIBPermittedChain')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPermittedChain resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpermittedchain.name", None), "name","SIBPermittedChain");
  if len(atts) != 0:
    print "Modifying SIBPermittedChain with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBPermittedChain configuration up to date.";

  Util.popPathElement('SIBPermittedChain');
