from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CustomService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCustomService");
  exportedObject.put("roleName", "WebSphereCustomService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customservice.externalconfigurl", objid, "externalConfigURL","CustomService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customservice.classpath", objid, "classpath","CustomService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customservice.classname", objid, "classname","CustomService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customservice.enable", objid, "enable","CustomService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customservice.displayname", objid, "displayName","CustomService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.customservice.description", objid, "description","CustomService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"CustomService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CustomService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('CustomService')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "externalConfigURL", roleProperties.optString("websphere.customservice.externalconfigurl", None));
  Util.addIfNotNone(properties, "classpath", roleProperties.optString("websphere.customservice.classpath", None));
  Util.addIfNotNone(properties, "classname", roleProperties.optString("websphere.customservice.classname", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.customservice.enable", None));
  Util.addIfNotNone(properties, "displayName", roleProperties.optString("websphere.customservice.displayname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.customservice.description", None));
  print "Creating CustomService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CustomService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CustomService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('CustomService')
  if not jsonobject.has("roleProperties"):
    raise Exception("CustomService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customservice.externalconfigurl", None), "externalConfigURL","CustomService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customservice.classpath", None), "classpath","CustomService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customservice.classname", None), "classname","CustomService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customservice.enable", None), "enable","CustomService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customservice.displayname", None), "displayName","CustomService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.customservice.description", None), "description","CustomService");
  if len(atts) != 0:
    print "Modifying CustomService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CustomService configuration up to date.";

  Property.removeProperties(objid,'properties',"CustomService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('CustomService');
