from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DigestAuthentication')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDigestAuthentication");
  exportedObject.put("roleName", "WebSphereDigestAuthentication");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.enabledigestauthenticationintegrity", objid, "enableDigestAuthenticationIntegrity","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.usercachecleanperiod", objid, "userCacheCleanPeriod","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.digestpasswordserverclass", objid, "digestPasswordServerClass","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.hashedrealm", objid, "hashedRealm","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.passwordattributename", objid, "passwordAttributeName","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.hashedcreds", objid, "hashedCreds","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.disablemultipleuseofnonce", objid, "disableMultipleUseOfNonce","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.disablesipbasicauth", objid, "disableSIPBasicAuth","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.cachecleanperiod", objid, "cacheCleanPeriod","DigestAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.digestauthentication.noncetimetolive", objid, "nonceTimeToLive","DigestAuthentication");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DigestAuthentication');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DigestAuthentication')
  if not jsonobject.has("roleProperties"):
    raise Exception("DigestAuthentication resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enableDigestAuthenticationIntegrity", roleProperties.optString("websphere.digestauthentication.enabledigestauthenticationintegrity", None));
  Util.addIfNotNone(properties, "userCacheCleanPeriod", roleProperties.optString("websphere.digestauthentication.usercachecleanperiod", None));
  Util.addIfNotNone(properties, "digestPasswordServerClass", roleProperties.optString("websphere.digestauthentication.digestpasswordserverclass", None));
  Util.addIfNotNone(properties, "hashedRealm", roleProperties.optString("websphere.digestauthentication.hashedrealm", None));
  Util.addIfNotNone(properties, "passwordAttributeName", roleProperties.optString("websphere.digestauthentication.passwordattributename", None));
  Util.addIfNotNone(properties, "hashedCreds", roleProperties.optString("websphere.digestauthentication.hashedcreds", None));
  Util.addIfNotNone(properties, "disableMultipleUseOfNonce", roleProperties.optString("websphere.digestauthentication.disablemultipleuseofnonce", None));
  Util.addIfNotNone(properties, "disableSIPBasicAuth", roleProperties.optString("websphere.digestauthentication.disablesipbasicauth", None));
  Util.addIfNotNone(properties, "cacheCleanPeriod", roleProperties.optString("websphere.digestauthentication.cachecleanperiod", None));
  Util.addIfNotNone(properties, "nonceTimeToLive", roleProperties.optString("websphere.digestauthentication.noncetimetolive", None));
  print "Creating DigestAuthentication with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DigestAuthentication", parentid, properties);
  Util.popPathElement('DigestAuthentication');

def update(objid,jsonobject):
  Util.pushPathElement('DigestAuthentication')
  if not jsonobject.has("roleProperties"):
    raise Exception("DigestAuthentication resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.enabledigestauthenticationintegrity", None), "enableDigestAuthenticationIntegrity","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.usercachecleanperiod", None), "userCacheCleanPeriod","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.digestpasswordserverclass", None), "digestPasswordServerClass","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.hashedrealm", None), "hashedRealm","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.passwordattributename", None), "passwordAttributeName","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.hashedcreds", None), "hashedCreds","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.disablemultipleuseofnonce", None), "disableMultipleUseOfNonce","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.disablesipbasicauth", None), "disableSIPBasicAuth","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.cachecleanperiod", None), "cacheCleanPeriod","DigestAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.digestauthentication.noncetimetolive", None), "nonceTimeToLive","DigestAuthentication");
  if len(atts) != 0:
    print "Modifying DigestAuthentication with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DigestAuthentication configuration up to date.";

  Util.popPathElement('DigestAuthentication');
