from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ModuleFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereModuleFile");
  exportedObject.put("roleName", "WebSphereModuleFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.modulefile.lastmodified", objid, "lastModified","ModuleFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.modulefile.originaluri", objid, "originalURI","ModuleFile");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.modulefile.types", objid, "types","ModuleFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.modulefile.directoryentry", objid, "directoryEntry","ModuleFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.modulefile.uri", objid, "URI","ModuleFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.modulefile.size", objid, "size","ModuleFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "ModuleFile");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ModuleFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ModuleFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("ModuleFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.modulefile.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.modulefile.originaluri", None));
  Util.addPathProperty(properties, "types", roleProperties.optString("websphere.modulefile.types", None));
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.modulefile.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.modulefile.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.modulefile.size", None));
  print "Creating ModuleFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ModuleFile", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ModuleFile');

def update(objid,jsonobject):
  Util.pushPathElement('ModuleFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("ModuleFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.modulefile.lastmodified", None), "lastModified","ModuleFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.modulefile.originaluri", None), "originalURI","ModuleFile");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.modulefile.types", None), "types","ModuleFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.modulefile.directoryentry", None), "directoryEntry","ModuleFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.modulefile.uri", None), "URI","ModuleFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.modulefile.size", None), "size","ModuleFile");
  if len(atts) != 0:
    print "Modifying ModuleFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ModuleFile configuration up to date.";

  File.removeFiles(objid, 'files',"ModuleFile");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ModuleFile');
