from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBPSBTopicTransactionality')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBPSBTopicTransactionality");
  exportedObject.put("roleName", "WebSphereSIBPSBTopicTransactionality");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbtopictransactionality.messagetype", objid, "messageType","SIBPSBTopicTransactionality");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibpsbtopictransactionality.batchsize", objid, "batchSize","SIBPSBTopicTransactionality");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBPSBTopicTransactionality');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBPSBTopicTransactionality')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPSBTopicTransactionality resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "messageType", roleProperties.optString("websphere.sibpsbtopictransactionality.messagetype", None));
  Util.addIfNotNone(properties, "batchSize", roleProperties.optString("websphere.sibpsbtopictransactionality.batchsize", None));
  print "Creating SIBPSBTopicTransactionality with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBPSBTopicTransactionality", parentid, properties);
  Util.popPathElement('SIBPSBTopicTransactionality');

def update(objid,jsonobject):
  Util.pushPathElement('SIBPSBTopicTransactionality')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBPSBTopicTransactionality resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbtopictransactionality.messagetype", None), "messageType","SIBPSBTopicTransactionality");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibpsbtopictransactionality.batchsize", None), "batchSize","SIBPSBTopicTransactionality");
  if len(atts) != 0:
    print "Modifying SIBPSBTopicTransactionality with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBPSBTopicTransactionality configuration up to date.";

  Util.popPathElement('SIBPSBTopicTransactionality');
