from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from WSNotificationRef import WSNotificationRef
from WSScheduleRef import WSScheduleRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSCertificateExpirationMonitor')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSCertificateExpirationMonitor");
  exportedObject.put("roleName", "WebSphereWSCertificateExpirationMonitor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wscertificateexpirationmonitor.certimplclasstoreplacecert", objid, "certImplClassToReplaceCert","WSCertificateExpirationMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wscertificateexpirationmonitor.autoreplace", objid, "autoReplace","WSCertificateExpirationMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wscertificateexpirationmonitor.name", objid, "name","WSCertificateExpirationMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wscertificateexpirationmonitor.isenabled", objid, "isEnabled","WSCertificateExpirationMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wscertificateexpirationmonitor.deleteold", objid, "deleteOld","WSCertificateExpirationMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wscertificateexpirationmonitor.daysbeforenotification", objid, "daysBeforeNotification","WSCertificateExpirationMonitor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  wsNotification = Util.getOptionalAttribute(objid, 'wsNotification', 'WSCertificateExpirationMonitor');
  if wsNotification is not None and len(wsNotification) > 0:
    returndict = Util.createTypeFolder(respath, "WSNotificationRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, WSNotificationRef._export(wsNotification, currespath, "WSNotification"));

  wsSchedule = Util.getOptionalAttribute(objid, 'wsSchedule', 'WSCertificateExpirationMonitor');
  if wsSchedule is not None and len(wsSchedule) > 0:
    returndict = Util.createTypeFolder(respath, "WSScheduleRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, WSScheduleRef._export(wsSchedule, currespath, "WSSchedule"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSCertificateExpirationMonitor');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSCertificateExpirationMonitor')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSCertificateExpirationMonitor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "certImplClassToReplaceCert", roleProperties.optString("websphere.wscertificateexpirationmonitor.certimplclasstoreplacecert", None));
  Util.addIfNotNone(properties, "autoReplace", roleProperties.optString("websphere.wscertificateexpirationmonitor.autoreplace", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wscertificateexpirationmonitor.name", None));
  Util.addIfNotNone(properties, "isEnabled", roleProperties.optString("websphere.wscertificateexpirationmonitor.isenabled", None));
  Util.addIfNotNone(properties, "deleteOld", roleProperties.optString("websphere.wscertificateexpirationmonitor.deleteold", None));
  Util.addIfNotNone(properties, "daysBeforeNotification", roleProperties.optString("websphere.wscertificateexpirationmonitor.daysbeforenotification", None));
  print "Creating WSCertificateExpirationMonitor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSCertificateExpirationMonitor", parentid, properties);

  if jsonobject.has('children'):
    for currjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = currjsonobject.getString('roleName');
      if currole == "WebSphereWSScheduleRef":
        WSScheduleRef.create(objid, currjsonobject, "wsSchedule");
      elif currole == "WebSphereWSNotificationRef":
        WSNotificationRef.create(objid, currjsonobject, "wsNotification");

  Util.popPathElement('WSCertificateExpirationMonitor');

def update(objid,jsonobject):
  Util.pushPathElement('WSCertificateExpirationMonitor')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSCertificateExpirationMonitor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wscertificateexpirationmonitor.certimplclasstoreplacecert", None), "certImplClassToReplaceCert","WSCertificateExpirationMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wscertificateexpirationmonitor.autoreplace", None), "autoReplace","WSCertificateExpirationMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wscertificateexpirationmonitor.name", None), "name","WSCertificateExpirationMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wscertificateexpirationmonitor.isenabled", None), "isEnabled","WSCertificateExpirationMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wscertificateexpirationmonitor.deleteold", None), "deleteOld","WSCertificateExpirationMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wscertificateexpirationmonitor.daysbeforenotification", None), "daysBeforeNotification","WSCertificateExpirationMonitor");

  if len(atts) != 0:
    print "Modifying WSCertificateExpirationMonitor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "WSCertificateExpirationMonitor configuration up to date.";

  Util.unsetAttribute(objid, "wsSchedule", "WSCertificateExpirationMonitor");

  if jsonobject.has('children'):
    for currjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = currjsonobject.getString('roleName');
      if currole == "WebSphereWSScheduleRef":
        WSScheduleRef.create(objid, currjsonobject, "wsSchedule");
      elif currole == "WebSphereWSNotificationRef":
        WSNotificationRef.create(objid, currjsonobject, "wsNotification");

  Util.popPathElement('WSCertificateExpirationMonitor');
