from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CompensationService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCompensationService");
  exportedObject.put("roleName", "WebSphereCompensationService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compensationservice.enable", objid, "enable","CompensationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compensationservice.compensationhandlerretrylimit", objid, "compensationHandlerRetryLimit","CompensationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compensationservice.recoverylogfilesize", objid, "recoveryLogFileSize","CompensationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compensationservice.recoverylogdirectory", objid, "recoveryLogDirectory","CompensationService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.compensationservice.compensationhandlerretryinterval", objid, "compensationHandlerRetryInterval","CompensationService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"CompensationService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CompensationService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('CompensationService')
  if not jsonobject.has("roleProperties"):
    raise Exception("CompensationService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.compensationservice.enable", None));
  Util.addIfNotNone(properties, "compensationHandlerRetryLimit", roleProperties.optString("websphere.compensationservice.compensationhandlerretrylimit", None));
  Util.addIfNotNone(properties, "recoveryLogFileSize", roleProperties.optString("websphere.compensationservice.recoverylogfilesize", None));
  Util.addIfNotNone(properties, "recoveryLogDirectory", roleProperties.optString("websphere.compensationservice.recoverylogdirectory", None));
  Util.addIfNotNone(properties, "compensationHandlerRetryInterval", roleProperties.optString("websphere.compensationservice.compensationhandlerretryinterval", None));
  print "Creating CompensationService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CompensationService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CompensationService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('CompensationService')
  if not jsonobject.has("roleProperties"):
    raise Exception("CompensationService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compensationservice.enable", None), "enable","CompensationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compensationservice.compensationhandlerretrylimit", None), "compensationHandlerRetryLimit","CompensationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compensationservice.recoverylogfilesize", None), "recoveryLogFileSize","CompensationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compensationservice.recoverylogdirectory", None), "recoveryLogDirectory","CompensationService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.compensationservice.compensationhandlerretryinterval", None), "compensationHandlerRetryInterval","CompensationService");
  if len(atts) != 0:
    print "Modifying CompensationService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CompensationService configuration up to date.";

  Property.removeProperties(objid,'properties',"CompensationService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CompensationService');
