from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JASPIConfiguration')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJASPIConfiguration");
  exportedObject.put("roleName", "WebSphereJASPIConfiguration");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaspiconfiguration.enabled", objid, "enabled","JASPIConfiguration");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaspiconfiguration.defaultprovidername", objid, "defaultProviderName","JASPIConfiguration");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JASPIConfiguration');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JASPIConfiguration')
  if not jsonobject.has("roleProperties"):
    raise Exception("JASPIConfiguration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.jaspiconfiguration.enabled", None));
  Util.addIfNotNone(properties, "defaultProviderName", roleProperties.optString("websphere.jaspiconfiguration.defaultprovidername", None));
  print "Creating JASPIConfiguration with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JASPIConfiguration", parentid, properties);
  Util.popPathElement('JASPIConfiguration');

def update(objid,jsonobject):
  Util.pushPathElement('JASPIConfiguration')
  if not jsonobject.has("roleProperties"):
    raise Exception("JASPIConfiguration resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaspiconfiguration.enabled", None), "enabled","JASPIConfiguration");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaspiconfiguration.defaultprovidername", None), "defaultProviderName","JASPIConfiguration");
  if len(atts) != 0:
    print "Modifying JASPIConfiguration with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JASPIConfiguration configuration up to date.";

  Util.popPathElement('JASPIConfiguration');
