from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AllAuthenticatedUsersInTrustedRealmsExt')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAllAuthenticatedUsersInTrustedRealmsExt");
  exportedObject.put("roleName", "WebSphereAllAuthenticatedUsersInTrustedRealmsExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.allauthenticatedusersintrustedrealmsext.name", objid, "name","AllAuthenticatedUsersInTrustedRealmsExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.allauthenticatedusersintrustedrealmsext.accessid", objid, "accessId","AllAuthenticatedUsersInTrustedRealmsExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AllAuthenticatedUsersInTrustedRealmsExt');
  return result;



def create(parentid, jsonobject, attName):
  Util.pushPathElement('AllAuthenticatedUsersInTrustedRealmsExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("AllAuthenticatedUsersInTrustedRealmsExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.allauthenticatedusersintrustedrealmsext.name", None));
  Util.addIfNotNone(properties, "accessId", roleProperties.optString("websphere.allauthenticatedusersintrustedrealmsext.accessid", None));
  print "Creating AllAuthenticatedUsersInTrustedRealmsExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AllAuthenticatedUsersInTrustedRealmsExt", parentid, properties, attName);
  Util.popPathElement('AllAuthenticatedUsersInTrustedRealmsExt');

def update(objid,jsonobject):
  Util.pushPathElement('AllAuthenticatedUsersInTrustedRealmsExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("AllAuthenticatedUsersInTrustedRealmsExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.allauthenticatedusersintrustedrealmsext.name", None), "name","AllAuthenticatedUsersInTrustedRealmsExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.allauthenticatedusersintrustedrealmsext.accessid", None), "accessId","AllAuthenticatedUsersInTrustedRealmsExt");
  if len(atts) != 0:
    print "Modifying AllAuthenticatedUsersInTrustedRealmsExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AllAuthenticatedUsersInTrustedRealmsExt configuration up to date.";

  Util.popPathElement('AllAuthenticatedUsersInTrustedRealmsExt');
