from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuthenticationMechanism')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuthenticationMechanism");
  exportedObject.put("roleName", "WebSphereAuthenticationMechanism");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationmechanism.customauthmechtype", objid, "customAuthMechType","AuthenticationMechanism");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationmechanism.authenticationmechanismtype", objid, "authenticationMechanismType","AuthenticationMechanism");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationmechanism.description", objid, "description","AuthenticationMechanism");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationmechanism.authenticationmechanism", objid, "authenticationMechanism","AuthenticationMechanism");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authenticationmechanism.credentialinterface", objid, "credentialInterface","AuthenticationMechanism");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  i = 0;
  typeFolders = {};
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'AuthenticationMechanism');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuthenticationMechanism');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuthenticationMechanism')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthenticationMechanism resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "customAuthMechType", roleProperties.optString("websphere.authenticationmechanism.customauthmechtype", None));
  Util.addIfNotNone(properties, "authenticationMechanismType", roleProperties.optString("websphere.authenticationmechanism.authenticationmechanismtype", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.authenticationmechanism.description", None));
  Util.addIfNotNone(properties, "authenticationMechanism", roleProperties.optString("websphere.authenticationmechanism.authenticationmechanism", None));
  Util.addIfNotNone(properties, "credentialInterface", roleProperties.optString("websphere.authenticationmechanism.credentialinterface", None));
  print "Creating AuthenticationMechanism with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuthenticationMechanism", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('AuthenticationMechanism');

def update(objid,jsonobject):
  Util.pushPathElement('AuthenticationMechanism')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthenticationMechanism resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationmechanism.customauthmechtype", None), "customAuthMechType","AuthenticationMechanism");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationmechanism.authenticationmechanismtype", None), "authenticationMechanismType","AuthenticationMechanism");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationmechanism.description", None), "description","AuthenticationMechanism");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationmechanism.authenticationmechanism", None), "authenticationMechanism","AuthenticationMechanism");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authenticationmechanism.credentialinterface", None), "credentialInterface","AuthenticationMechanism");
  if len(atts) != 0:
    print "Modifying AuthenticationMechanism with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuthenticationMechanism configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'AuthenticationMechanism');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('AuthenticationMechanism');
