from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AverageResponseTimeGoal')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAverageResponseTimeGoal");
  exportedObject.put("roleName", "WebSphereAverageResponseTimeGoal");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.averageresponsetimegoal.importance", objid, "importance","AverageResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.averageresponsetimegoal.goalvalue", objid, "goalValue","AverageResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.averageresponsetimegoal.timeperiodvalueunits", objid, "timePeriodValueUnits","AverageResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.averageresponsetimegoal.violationenabled", objid, "violationEnabled","AverageResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.averageresponsetimegoal.goaldeltavalueunits", objid, "goalDeltaValueUnits","AverageResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.averageresponsetimegoal.goalvalueunits", objid, "goalValueUnits","AverageResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.averageresponsetimegoal.goaldeltavalue", objid, "goalDeltaValue","AverageResponseTimeGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.averageresponsetimegoal.timeperiodvalue", objid, "timePeriodValue","AverageResponseTimeGoal");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AverageResponseTimeGoal');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AverageResponseTimeGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("AverageResponseTimeGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "importance", roleProperties.optString("websphere.averageresponsetimegoal.importance", None));
  Util.addIfNotNone(properties, "goalValue", roleProperties.optString("websphere.averageresponsetimegoal.goalvalue", None));
  Util.addIfNotNone(properties, "timePeriodValueUnits", roleProperties.optString("websphere.averageresponsetimegoal.timeperiodvalueunits", None));
  Util.addIfNotNone(properties, "violationEnabled", roleProperties.optString("websphere.averageresponsetimegoal.violationenabled", None));
  Util.addIfNotNone(properties, "goalDeltaValueUnits", roleProperties.optString("websphere.averageresponsetimegoal.goaldeltavalueunits", None));
  Util.addIfNotNone(properties, "goalValueUnits", roleProperties.optString("websphere.averageresponsetimegoal.goalvalueunits", None));
  Util.addIfNotNone(properties, "goalDeltaValue", roleProperties.optString("websphere.averageresponsetimegoal.goaldeltavalue", None));
  Util.addIfNotNone(properties, "timePeriodValue", roleProperties.optString("websphere.averageresponsetimegoal.timeperiodvalue", None));
  print "Creating AverageResponseTimeGoal with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AverageResponseTimeGoal", parentid, properties);
  Util.popPathElement('AverageResponseTimeGoal');

def update(objid,jsonobject):
  Util.pushPathElement('AverageResponseTimeGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("AverageResponseTimeGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.averageresponsetimegoal.importance", None), "importance","AverageResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.averageresponsetimegoal.goalvalue", None), "goalValue","AverageResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.averageresponsetimegoal.timeperiodvalueunits", None), "timePeriodValueUnits","AverageResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.averageresponsetimegoal.violationenabled", None), "violationEnabled","AverageResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.averageresponsetimegoal.goaldeltavalueunits", None), "goalDeltaValueUnits","AverageResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.averageresponsetimegoal.goalvalueunits", None), "goalValueUnits","AverageResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.averageresponsetimegoal.goaldeltavalue", None), "goalDeltaValue","AverageResponseTimeGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.averageresponsetimegoal.timeperiodvalue", None), "timePeriodValue","AverageResponseTimeGoal");
  if len(atts) != 0:
    print "Modifying AverageResponseTimeGoal with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AverageResponseTimeGoal configuration up to date.";

  Util.popPathElement('AverageResponseTimeGoal');
