from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.ejbnamespacebinding.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'EjbNameSpaceBinding');

  containmentpath = "%(parentconpath)sEjbNameSpaceBinding:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('EjbNameSpaceBinding')

  name = Util.getRequiredAttribute(objid, "name", 'EjbNameSpaceBinding');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEjbNameSpaceBinding");
  exportedObject.put("roleName", "WebSphereEjbNameSpaceBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbnamespacebinding.bindinglocation", objid, "bindingLocation","EjbNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbnamespacebinding.name", objid, "name","EjbNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbnamespacebinding.ejbjndiname", objid, "ejbJndiName","EjbNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbnamespacebinding.applicationservername", objid, "applicationServerName","EjbNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbnamespacebinding.nameinnamespace", objid, "nameInNameSpace","EjbNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbnamespacebinding.applicationnodename", objid, "applicationNodeName","EjbNameSpaceBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EjbNameSpaceBinding');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("EjbNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.ejbnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.ejbnamespacebinding.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      if parentid == None or len(parentid) == 0:
        raise Exception("Parent does not exist to create EjbNameSpaceBinding on.");
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('EjbNameSpaceBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("EjbNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.ejbnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.ejbnamespacebinding.name!");

  properties = [];
  Util.addIfNotNone(properties, "bindingLocation", roleProperties.optString("websphere.ejbnamespacebinding.bindinglocation", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.ejbnamespacebinding.name", None));
  Util.addIfNotNone(properties, "ejbJndiName", roleProperties.optString("websphere.ejbnamespacebinding.ejbjndiname", None));
  Util.addIfNotNone(properties, "applicationServerName", roleProperties.optString("websphere.ejbnamespacebinding.applicationservername", None));
  Util.addIfNotNone(properties, "nameInNameSpace", roleProperties.optString("websphere.ejbnamespacebinding.nameinnamespace", None));
  Util.addIfNotNone(properties, "applicationNodeName", roleProperties.optString("websphere.ejbnamespacebinding.applicationnodename", None));
  print "Creating EjbNameSpaceBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EjbNameSpaceBinding", parentid, properties);
  Util.popPathElement('EjbNameSpaceBinding');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('EjbNameSpaceBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("EjbNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.ejbnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.ejbnamespacebinding.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbnamespacebinding.bindinglocation", None), "bindingLocation","EjbNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbnamespacebinding.name", None), "name","EjbNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbnamespacebinding.ejbjndiname", None), "ejbJndiName","EjbNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbnamespacebinding.applicationservername", None), "applicationServerName","EjbNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbnamespacebinding.nameinnamespace", None), "nameInNameSpace","EjbNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbnamespacebinding.applicationnodename", None), "applicationNodeName","EjbNameSpaceBinding");
  if len(atts) != 0:
    print "Modifying EjbNameSpaceBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EjbNameSpaceBinding configuration up to date.";

  Util.popPathElement('EjbNameSpaceBinding');
