from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "JobLogLimit";

  containmentpath = "%(parentconpath)sJobLogLimit:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JobLogLimit')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJobLogLimit");
  exportedObject.put("roleName", "WebSphereJobLogLimit");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobloglimit.maxclassspace", objid, "maxClassSpace","JobLogLimit");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobloglimit.maxfileage", objid, "maxFileAge","JobLogLimit");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JobLogLimit');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("JobLogLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create JobLogLimit on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;

def create(parentid, jsonobject):
  Util.pushPathElement('JobLogLimit')
  if not jsonobject.has("roleProperties"):
    raise Exception("JobLogLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "maxClassSpace", roleProperties.optString("websphere.jobloglimit.maxclassspace", None));
  Util.addIfNotNone(properties, "maxFileAge", roleProperties.optString("websphere.jobloglimit.maxfileage", None));
  print "Creating JobLogLimit with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JobLogLimit", parentid, properties);
  Util.popPathElement('JobLogLimit');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('JobLogLimit')
  if not jsonobject.has("roleProperties"):
    raise Exception("JobLogLimit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobloglimit.maxclassspace", None), "maxClassSpace","JobLogLimit");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobloglimit.maxfileage", None), "maxFileAge","JobLogLimit");
  if len(atts) != 0:
    print "Modifying JobLogLimit with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JobLogLimit configuration up to date.";

  Util.popPathElement('JobLogLimit');
