from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQServerBusMember')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQServerBusMember");
  exportedObject.put("roleName", "WebSphereSIBMQServerBusMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.uuid", objid, "uuid","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.name", objid, "name","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.port", objid, "port","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.trustmessageuseridentifiers", objid, "trustMessageUserIdentifiers","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.channel", objid, "channel","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.virtualqueuemanagername", objid, "virtualQueueManagerName","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.mqserveruuid", objid, "mqServerUuid","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.messagingauthalias", objid, "messagingAuthAlias","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.overridedefaultconnectionsettings", objid, "overrideDefaultConnectionSettings","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.host", objid, "host","SIBMQServerBusMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqserverbusmember.transportchainname", objid, "transportChainName","SIBMQServerBusMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQServerBusMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQServerBusMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQServerBusMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmqserverbusmember.uuid", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibmqserverbusmember.name", None));
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.sibmqserverbusmember.port", None));
  Util.addIfNotNone(properties, "trustMessageUserIdentifiers", roleProperties.optString("websphere.sibmqserverbusmember.trustmessageuseridentifiers", None));
  Util.addIfNotNone(properties, "channel", roleProperties.optString("websphere.sibmqserverbusmember.channel", None));
  Util.addIfNotNone(properties, "virtualQueueManagerName", roleProperties.optString("websphere.sibmqserverbusmember.virtualqueuemanagername", None));
  Util.addIfNotNone(properties, "mqServerUuid", roleProperties.optString("websphere.sibmqserverbusmember.mqserveruuid", None));
  Util.addIfNotNone(properties, "messagingAuthAlias", roleProperties.optString("websphere.sibmqserverbusmember.messagingauthalias", None));
  Util.addIfNotNone(properties, "overrideDefaultConnectionSettings", roleProperties.optString("websphere.sibmqserverbusmember.overridedefaultconnectionsettings", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.sibmqserverbusmember.host", None));
  Util.addIfNotNone(properties, "transportChainName", roleProperties.optString("websphere.sibmqserverbusmember.transportchainname", None));
  print "Creating SIBMQServerBusMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQServerBusMember", parentid, properties);
  Util.popPathElement('SIBMQServerBusMember');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQServerBusMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQServerBusMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.uuid", None), "uuid","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.name", None), "name","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.port", None), "port","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.trustmessageuseridentifiers", None), "trustMessageUserIdentifiers","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.channel", None), "channel","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.virtualqueuemanagername", None), "virtualQueueManagerName","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.mqserveruuid", None), "mqServerUuid","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.messagingauthalias", None), "messagingAuthAlias","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.overridedefaultconnectionsettings", None), "overrideDefaultConnectionSettings","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.host", None), "host","SIBMQServerBusMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqserverbusmember.transportchainname", None), "transportChainName","SIBMQServerBusMember");
  if len(atts) != 0:
    print "Modifying SIBMQServerBusMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQServerBusMember configuration up to date.";

  Util.popPathElement('SIBMQServerBusMember');
