from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TaskProvider')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTaskProvider");
  exportedObject.put("roleName", "WebSphereTaskProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.taskprovider.classpath", objid, "classpath","TaskProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.taskprovider.implementationclassname", objid, "implementationClassName","TaskProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.taskprovider.weight", objid, "weight","TaskProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TaskProvider');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TaskProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("TaskProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.taskprovider.classpath", None));
  Util.addIfNotNone(properties, "implementationClassName", roleProperties.optString("websphere.taskprovider.implementationclassname", None));
  Util.addIfNotNone(properties, "weight", roleProperties.optString("websphere.taskprovider.weight", None));
  print "Creating TaskProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TaskProvider", parentid, properties);
  Util.popPathElement('TaskProvider');

def update(objid,jsonobject):
  Util.pushPathElement('TaskProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("TaskProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.taskprovider.classpath", None), "classpath","TaskProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.taskprovider.implementationclassname", None), "implementationClassName","TaskProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.taskprovider.weight", None), "weight","TaskProvider");
  if len(atts) != 0:
    print "Modifying TaskProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TaskProvider configuration up to date.";

  Util.popPathElement('TaskProvider');
