from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('HPELTextLog')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHPELTextLog");
  exportedObject.put("roleName", "WebSphereHPELTextLog");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.outofspaceaction", objid, "outOfSpaceAction","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.bufferingenabled", objid, "bufferingEnabled","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.purgemaxsize", objid, "purgeMaxSize","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.datadirectory", objid, "dataDirectory","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.traceincluded", objid, "traceIncluded","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.fileswitchenabled", objid, "fileSwitchEnabled","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.outputformat", objid, "outputFormat","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.enabled", objid, "enabled","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.purgemintime", objid, "purgeMinTime","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.fileswitchtime", objid, "fileSwitchTime","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.purgebysizeenabled", objid, "purgeBySizeEnabled","HPELTextLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.hpeltextlog.purgebytimeenabled", objid, "purgeByTimeEnabled","HPELTextLog");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HPELTextLog');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('HPELTextLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("HPELTextLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "outOfSpaceAction", roleProperties.optString("websphere.hpeltextlog.outofspaceaction", None));
  Util.addIfNotNone(properties, "bufferingEnabled", roleProperties.optString("websphere.hpeltextlog.bufferingenabled", None));
  Util.addIfNotNone(properties, "purgeMaxSize", roleProperties.optString("websphere.hpeltextlog.purgemaxsize", None));
  Util.addIfNotNone(properties, "dataDirectory", roleProperties.optString("websphere.hpeltextlog.datadirectory", None));
  Util.addIfNotNone(properties, "traceIncluded", roleProperties.optString("websphere.hpeltextlog.traceincluded", None));
  Util.addIfNotNone(properties, "fileSwitchEnabled", roleProperties.optString("websphere.hpeltextlog.fileswitchenabled", None));
  Util.addIfNotNone(properties, "outputFormat", roleProperties.optString("websphere.hpeltextlog.outputformat", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.hpeltextlog.enabled", None));
  Util.addIfNotNone(properties, "purgeMinTime", roleProperties.optString("websphere.hpeltextlog.purgemintime", None));
  Util.addIfNotNone(properties, "fileSwitchTime", roleProperties.optString("websphere.hpeltextlog.fileswitchtime", None));
  Util.addIfNotNone(properties, "purgeBySizeEnabled", roleProperties.optString("websphere.hpeltextlog.purgebysizeenabled", None));
  Util.addIfNotNone(properties, "purgeByTimeEnabled", roleProperties.optString("websphere.hpeltextlog.purgebytimeenabled", None));
  print "Creating HPELTextLog with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HPELTextLog", parentid, properties);
  Util.popPathElement('HPELTextLog');

def update(objid,jsonobject):
  Util.pushPathElement('HPELTextLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("HPELTextLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.outofspaceaction", None), "outOfSpaceAction","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.bufferingenabled", None), "bufferingEnabled","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.purgemaxsize", None), "purgeMaxSize","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.datadirectory", None), "dataDirectory","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.traceincluded", None), "traceIncluded","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.fileswitchenabled", None), "fileSwitchEnabled","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.outputformat", None), "outputFormat","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.enabled", None), "enabled","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.purgemintime", None), "purgeMinTime","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.fileswitchtime", None), "fileSwitchTime","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.purgebysizeenabled", None), "purgeBySizeEnabled","HPELTextLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.hpeltextlog.purgebytimeenabled", None), "purgeByTimeEnabled","HPELTextLog");
  if len(atts) != 0:
    print "Modifying HPELTextLog with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HPELTextLog configuration up to date.";

  Util.popPathElement('HPELTextLog');
