from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthIdentityAdopter import SIBAuthIdentityAdopter;
from SIBAuthSender import SIBAuthSender;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthForeignBus')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthForeignBus");
  exportedObject.put("roleName", "WebSphereSIBAuthForeignBus");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthforeignbus.busname", objid, "busName","SIBAuthForeignBus");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthForeignBus');
  if identityAdopter is not None and len(identityAdopter) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthIdentityAdopter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthIdentityAdopter._export(identityAdopter, currespath, "SIBAuthIdentityAdopter"));

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthForeignBus');
  if sender is not None and len(sender) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthSender", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthSender._export(sender, currespath, "SIBAuthSender"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthForeignBus');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthForeignBus')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthForeignBus resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.sibauthforeignbus.busname", None));
  print "Creating SIBAuthForeignBus with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthForeignBus", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthForeignBus');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthForeignBus')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthForeignBus resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthforeignbus.busname", None), "busName","SIBAuthForeignBus");
  if len(atts) != 0:
    print "Modifying SIBAuthForeignBus with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthForeignBus configuration up to date.";

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthForeignBus');
  if identityAdopter is not None and len(identityAdopter) > 0:
    Util.remove(identityAdopter);

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthForeignBus');
  if sender is not None and len(sender) > 0:
    Util.remove(sender);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthForeignBus');
