from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIPProxyInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'SIPProxyInboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIPProxyInboundChannel");
  exportedObject.put("roleName", "WebSphereSIPProxyInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxyinboundchannel.name", objid, "name","SIPProxyInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sipproxyinboundchannel.discriminationweight", objid, "discriminationWeight","SIPProxyInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SIPProxyInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIPProxyInboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIPProxyInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPProxyInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sipproxyinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.sipproxyinboundchannel.discriminationweight", None));
  print "Creating SIPProxyInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIPProxyInboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPProxyInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('SIPProxyInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIPProxyInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxyinboundchannel.name", None), "name","SIPProxyInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sipproxyinboundchannel.discriminationweight", None), "discriminationWeight","SIPProxyInboundChannel");
  if len(atts) != 0:
    print "Modifying SIPProxyInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIPProxyInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"SIPProxyInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SIPProxyInboundChannel');
