from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecurityRoleRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecurityRoleRef");
  exportedObject.put("roleName", "WebSphereSecurityRoleRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityroleref.name", objid, "name","SecurityRoleRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityroleref.link", objid, "link","SecurityRoleRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityroleref.description", objid, "description","SecurityRoleRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'SecurityRoleRef');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecurityRoleRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecurityRoleRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityRoleRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.securityroleref.name", None));
  Util.addIfNotNone(properties, "link", roleProperties.optString("websphere.securityroleref.link", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.securityroleref.description", None));
  print "Creating SecurityRoleRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecurityRoleRef", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('SecurityRoleRef');

def update(objid,jsonobject):
  Util.pushPathElement('SecurityRoleRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityRoleRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityroleref.name", None), "name","SecurityRoleRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityroleref.link", None), "link","SecurityRoleRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityroleref.description", None), "description","SecurityRoleRef");
  if len(atts) != 0:
    print "Modifying SecurityRoleRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SecurityRoleRef configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'SecurityRoleRef');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
  Util.popPathElement('SecurityRoleRef');
