from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('UDDIConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereUDDIConfig");
  exportedObject.put("roleName", "WebSphereUDDIConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddiconfig.getservleturlprefix", objid, "getServletURLPrefix","UDDIConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddiconfig.dbmaxresultcount", objid, "dbMaxResultCount","UDDIConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddiconfig.persister", objid, "persister","UDDIConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddiconfig.maxsearchkeys", objid, "maxSearchKeys","UDDIConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddiconfig.getservletname", objid, "getServletName","UDDIConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddiconfig.operatorname", objid, "operatorName","UDDIConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddiconfig.defaultlanguage", objid, "defaultLanguage","UDDIConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('UDDIConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('UDDIConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("UDDIConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "getServletURLPrefix", roleProperties.optString("websphere.uddiconfig.getservleturlprefix", None));
  Util.addIfNotNone(properties, "dbMaxResultCount", roleProperties.optString("websphere.uddiconfig.dbmaxresultcount", None));
  Util.addIfNotNone(properties, "persister", roleProperties.optString("websphere.uddiconfig.persister", None));
  Util.addIfNotNone(properties, "maxSearchKeys", roleProperties.optString("websphere.uddiconfig.maxsearchkeys", None));
  Util.addIfNotNone(properties, "getServletName", roleProperties.optString("websphere.uddiconfig.getservletname", None));
  Util.addIfNotNone(properties, "operatorName", roleProperties.optString("websphere.uddiconfig.operatorname", None));
  Util.addIfNotNone(properties, "defaultLanguage", roleProperties.optString("websphere.uddiconfig.defaultlanguage", None));
  print "Creating UDDIConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("UDDIConfig", parentid, properties);
  Util.popPathElement('UDDIConfig');

def update(objid,jsonobject):
  Util.pushPathElement('UDDIConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("UDDIConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddiconfig.getservleturlprefix", None), "getServletURLPrefix","UDDIConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddiconfig.dbmaxresultcount", None), "dbMaxResultCount","UDDIConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddiconfig.persister", None), "persister","UDDIConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddiconfig.maxsearchkeys", None), "maxSearchKeys","UDDIConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddiconfig.getservletname", None), "getServletName","UDDIConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddiconfig.operatorname", None), "operatorName","UDDIConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddiconfig.defaultlanguage", None), "defaultLanguage","UDDIConfig");
  if len(atts) != 0:
    print "Modifying UDDIConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "UDDIConfig configuration up to date.";

  Util.popPathElement('UDDIConfig');
