from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('UserRegistry')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereUserRegistry");
  exportedObject.put("roleName", "WebSphereUserRegistry");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userregistry.useregistryrealm", objid, "useRegistryRealm","UserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userregistry.serverpassword", objid, "serverPassword","UserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userregistry.primaryadminid", objid, "primaryAdminId","UserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userregistry.useregistryserverid", objid, "useRegistryServerId","UserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userregistry.limit", objid, "limit","UserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userregistry.serverid", objid, "serverId","UserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userregistry.realm", objid, "realm","UserRegistry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.userregistry.ignorecase", objid, "ignoreCase","UserRegistry");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"UserRegistry");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('UserRegistry');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('UserRegistry')
  if not jsonobject.has("roleProperties"):
    raise Exception("UserRegistry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "useRegistryRealm", roleProperties.optString("websphere.userregistry.useregistryrealm", None));
  Util.addIfNotNone(properties, "serverPassword", roleProperties.optString("websphere.userregistry.serverpassword", None));
  Util.addIfNotNone(properties, "primaryAdminId", roleProperties.optString("websphere.userregistry.primaryadminid", None));
  Util.addIfNotNone(properties, "useRegistryServerId", roleProperties.optString("websphere.userregistry.useregistryserverid", None));
  Util.addIfNotNone(properties, "limit", roleProperties.optString("websphere.userregistry.limit", None));
  Util.addIfNotNone(properties, "serverId", roleProperties.optString("websphere.userregistry.serverid", None));
  Util.addIfNotNone(properties, "realm", roleProperties.optString("websphere.userregistry.realm", None));
  Util.addIfNotNone(properties, "ignoreCase", roleProperties.optString("websphere.userregistry.ignorecase", None));
  print "Creating UserRegistry with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("UserRegistry", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('UserRegistry');

def update(objid,jsonobject):
  Util.pushPathElement('UserRegistry')
  if not jsonobject.has("roleProperties"):
    raise Exception("UserRegistry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userregistry.useregistryrealm", None), "useRegistryRealm","UserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userregistry.serverpassword", None), "serverPassword","UserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userregistry.primaryadminid", None), "primaryAdminId","UserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userregistry.useregistryserverid", None), "useRegistryServerId","UserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userregistry.limit", None), "limit","UserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userregistry.serverid", None), "serverId","UserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userregistry.realm", None), "realm","UserRegistry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.userregistry.ignorecase", None), "ignoreCase","UserRegistry");
  if len(atts) != 0:
    print "Modifying UserRegistry with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "UserRegistry configuration up to date.";

  Property.removeProperties(objid, 'properties',"UserRegistry");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('UserRegistry');
